#version 120


#define MAX_LIGHTS 14
in vec3 alightVec[MAX_LIGHTS];

in vec2 texCoord;

uniform float testvalue;

in vec3 v;
in vec3 N;
in vec3 T;
in vec3 B;

uniform vec4 flash;
uniform vec4 glColor;
uniform vec3 camPos;

uniform float lightsPosx[MAX_LIGHTS];
uniform float lightsPosy[MAX_LIGHTS];
uniform float lightsPosz[MAX_LIGHTS];



uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];


uniform float lightsAmbientr[MAX_LIGHTS];
uniform float lightsAmbientg[MAX_LIGHTS];
uniform float lightsAmbientb[MAX_LIGHTS];

uniform float lightsDiffuser[MAX_LIGHTS];
uniform float lightsDiffuseg[MAX_LIGHTS];
uniform float lightsDiffuseb[MAX_LIGHTS];

uniform float lightsSpecularr[MAX_LIGHTS];
uniform float lightsSpecularg[MAX_LIGHTS];
uniform float lightsSpecularb[MAX_LIGHTS];



uniform sampler2D colorMap;

uniform sampler2D biglightMap;
uniform float xmin;
uniform float xmax;
uniform float zmin;
uniform float zmax;

uniform sampler2D normalMap;




vec3 CalcBumpedNormal()
{
    vec3 Normal = N;
    vec3 Tangent = T;
    Tangent = normalize(Tangent - dot(Tangent, Normal) * Normal);
    
    vec3 Bitangent = B;
    vec3 BumpMapNormal = texture2D(normalMap, texCoord).xyz;
    BumpMapNormal = 2.0 * BumpMapNormal - vec3(1.0, 1.0, 1.0);
    vec3 NewNormal;
    mat3 TBN = mat3(Tangent, Bitangent, Normal);
    NewNormal = TBN * BumpMapNormal;
    NewNormal = normalize(NewNormal);
    return NewNormal;
}

void main (void)
{

    vec3 lightVec;
    vec3 eyeVec;
    vec4 accvDiffuse = vec4(0.0);
    vec4 accvSpecular = vec4(0.0);
    float distSqr;
    vec3 lVec;
    vec3 vVec;
    float att;
    vec4 base;
    vec4 vAmbient;
    vec3 bump;
    float diffuse;
    vec4 vDiffuse;
    vec4 vSpecular;
    float specular;
    vec3 nrmltexture;

    base = texture2D(colorMap, texCoord);
    
    vAmbient = vec4(1.0f,1.0f,1.0f,1.0f)
               * vec4(lightsAmbientr[0],lightsAmbientg[0],lightsAmbientb[0],1.0f);
    
    




































    
    
    
    vAmbient = vec4(0.4,0.4,0.4,1.0);
    accvDiffuse=vec4(vec3(max(dot(N,vec3(-1.1,1.0,-0.9)),0.0)),1.0);

    




    vec3 viewDir = normalize(camPos-v);
    bump=CalcBumpedNormal();
    vec3 L = normalize(vec3(-1.1,1.0,-0.9) - v);
    vec3 E = normalize(-v);
    vec3 R = normalize(-reflect(L,N));
    vec3 lightDir = L;
    vec3 reflectDir=reflect(-lightDir,bump);
    const float shininess=1.5f;
    accvSpecular = vec4(pow(clamp(dot(viewDir,reflectDir)*shininess,0.0,1.0),1.2)); 

    
    gl_FragColor = ((vAmbient*base + accvDiffuse/1.33*0.45*base + accvSpecular*base));
    
    gl_FragColor *= glColor;

    vec2 texCoord2=vec2((v.x-xmin)/(xmax-xmin),(v.z-zmin)/(zmax-zmin));
    vec4 lmap=texture2D(biglightMap, texCoord2);
    gl_FragColor *= lmap*vec4(1.0, 1.0, 1.0, 1.0);
    gl_FragColor += lmap*vec4(0.275, 0.275, 0.275, 1.0);

    float fog=clamp(length(v-camPos),0.0,550.0)/550.0;
    gl_FragColor = gl_FragColor*(1.0-fog)+vec4(43.0/256.0,75.0/256.0,152.0/256.0,1.0)/1.25*fog;
    gl_FragColor.a=1.0; 

    

    

    
    
    
}











